---
title: IDM-VTON AI Model Usage Guide
slug: TaQ6XsKxYhbY62kmBLv72
createdAt: Thu Jul 18 2024 05:50:21 GMT+0000 (Coordinated Universal Time)
updatedAt: Thu Jul 18 2024 13:44:27 GMT+0000 (Coordinated Universal Time)
---

# IDM-VTON AI Model Usage Guide

## Introduction

This document describes how to use the aonweb library to call the IDM-VTON AI model. This model is used for virtual try-on, allowing specified clothing images to be applied to human images.

## Prerequisites

- Node.js environment
- `aonweb` library installed
- Valid Aonet APPID

## Basic Usage

### 1. Import Required Modules

```js
import { AI, AIOptions } from 'aonweb';
```

### 2. Initialize AI Instance

```js
const ai_options = new AIOptions({
    appId: 'your_app_id_here',
    dev_mode: true
});

const aonweb = new AI(ai_options);
```

### 3. Prepare Input Data Example

```js
const data = {
    input: {
      "crop": false,
      "seed": 42,
      "steps": 30,
      "category": "upper_body",
      "force_dc": false,
      "garm_img": "https://replicate.delivery/pbxt/KgwTlZyFx5aUU3gc5gMiKuD5nNPTgliMlLUWx160G4z99YjO/sweater.webp",
      "mask_img": "https://replicate.delivery/pbxt/KnaDKqnN0h1DDF5CnK7iRSSkFnJrk9kyRiQlcc5gBcy8gpPA/replicate-prediction-wfj8g6sgmxrgp0cf1gnv7btfh8.jpg",
      "human_img": "https://replicate.delivery/pbxt/KgwTlhCMvDagRrcVzZJbuozNJ8esPqiNAIJS3eMgHrYuHmW4/KakaoTalk_Photo_2024-04-04-21-44-45.png",
      "garment_des": "cute pink top"
    }
};
```

### 4. Call the AI Model

```js
const price = 8; // Cost of the AI call
try {
    const response = await aonweb.prediction("/predictions/ai/idm-vton@cuuupid", data, price);
    // Handle response
    console.log("IDM-VTON Response:", response);
} catch (error) {
    // Error handling
     console.error("Error generate :", error);
}
```

### Parameter Description

- `seed`: Number,Random seed for generating reproducible results
- `steps`: Number,Provide the steps required for model inference
- `garm_img`: String,Garment, should match the category, can be a product image or even a photo of someone
- `human_img`: String,Model, if this is not 3:4 check crop
- `garment_des`: String,Description of garment e.g. Short Sleeve Round Neck T-shirt
- `crop` Boolean,Use cropping? (check this if your image is not 3:4)
- `category` String,Category of garment
- `force_dc` Boolean,Use the DressCode version of IDM-VTON (this is default false, except if category=dresses)
- `mask_img` String,Mask image, optional (but faster)

### Handling the Response

The model's response will contain the processed results. Depending on your application's needs, you may need to parse and use specific fields from the response.

### Error Handling

Use try-catch blocks to catch and handle possible errors.

## Best Practices

- **Store and Manage API Keys**: Do not hard-code API keys in your code. Use environment variables or secure key management systems.
- **Input Validation**: Validate all input parameters before sending requests.
- **Error Handling**: Implement comprehensive error handling, including network errors, API limits, and invalid responses.
- **Caching Strategy**: Consider implementing caching mechanisms to reduce duplicate requests and improve application performance.
- **Asynchronous Processing**: Use async/await or Promises to handle asynchronous operations, ensuring the main thread is not blocked.

### Notes

- Ensure you have enough API call quota.
- Ensure the validity and accessibility of image URLs.
- Adhere to the API provider's terms of use and restrictions.


## Conclusion

By following this guide, you should be able to successfully integrate and use the IDM-VTON AI model for virtual try-on application development. If you encounter any issues or need further assistance, please refer to the official aonweb documentation or contact technical support.
